#include <allegro.h>

#include "actor.h"
#include "draw.h"
#include "alienship.h"
#include "sectors.h"
#include "man.h"

ACTOR all_mans[TOTAL_MANS];
int mans_total = 0;
ACTOR *man[ACTIVE_MANS];
int mans_num = 0;

float man0_points[] = {
	     0.000,      0.526, // 0
	     4.736,      0.526, // 1
	     1.053,      7.368, // 2
	     0.526,     15.788, // 3
	     1.053,     27.366, // 4
	     1.579,     38.944, // 5
	    13.157,     39.470, // 6
	    14.209,     26.314, // 7
	     6.842,     34.734, // 8
	    11.052,     34.734, // 9
	     8.420,     29.997, // 10
	    14.209,     33.681, // 11
	    19.998,     32.103, // 12
	    14.209,     30.524, // 13
	     3.158,      7.894, // 14
	     2.105,      1.579, // 15
	     6.315,      1.053, // 16
	    -3.684,     18.946, // 17
	     5.789,     19.472, // 18
	     9.999,     18.946, // 19
	    -1.053,     21.051, // 20
	     4.736,     21.577, // 21
	     9.999,     21.577  // 22
};
int man0_lines[] = {
	2, 3, 0, 0, 0,
	2, 0, 0, 0, 0,
	0, 1, 0, 0, 0,
	4, 3, 0, 0, 0,
	7, 4, 0, 0, 0,
	4, 5, 0, 0, 0,
	5, 6, 0, 0, 0,
	9, 8, 0, 0, 0,
	10, 7, 0, 0, 0,
	11, 6, 0, 0, 0,
	11, 12, 0, 0, 0,
	12, 13, 0, 0, 0,
	13, 7, 0, 0, 0,
	16, 15, 0, 0, 0,
	15, 14, 0, 0, 0,
	14, 3, 0, 0, 0,
	19, 18, 0, 0, 0,
	18, 17, 0, 0, 0,
	17, 4, 0, 0, 0,
	22, 21, 0, 0, 0,
	21, 20, 0, 0, 0,
	20, 4, 0, 0, 0,
};
float man1_points[] = {
	   -12.013,      1.502, // 0
	    -7.008,      1.001, // 1
	    -7.508,      7.008, // 2
	     0.501,     15.017, // 3
	    -2.286,     25.972, // 4
	    -4.872,     36.722, // 5
	     7.292,     40.022, // 6
	    10.313,     26.299, // 7
	     2.787,     32.785, // 8
	     6.254,     33.293, // 9
	     4.853,     29.040, // 10
	     8.803,     33.160, // 11
	    15.954,     32.690, // 12
	     9.806,     29.766, // 13
	     8.509,      7.508, // 14
	    13.014,      1.001, // 15
	    17.019,      1.502, // 16
	    -9.010,     18.520, // 17
	    -2.000,     12.000, // 18
	     4.004,     11.513, // 19
	     7.508,     20.523, // 20
	    14.015,     21.023, // 21
	    19.521,     21.524  // 22
};
int man1_lines[] = {
	2, 3, 0, 0, 0,
	2, 0, 0, 0, 0,
	0, 1, 0, 0, 0,
	4, 3, 0, 0, 0,
	7, 4, 0, 0, 0,
	4, 5, 0, 0, 0,
	5, 6, 0, 0, 0,
	9, 8, 0, 0, 0,
	10, 7, 0, 0, 0,
	11, 6, 0, 0, 0,
	11, 12, 0, 0, 0,
	12, 13, 0, 0, 0,
	13, 7, 0, 0, 0,
	16, 15, 0, 0, 0,
	15, 14, 0, 0, 0,
	14, 3, 0, 0, 0,
	19, 18, 0, 0, 0,
	18, 17, 0, 0, 0,
	17, 4, 0, 0, 0,
	22, 21, 0, 0, 0,
	21, 20, 0, 0, 0,
	20, 4, 0, 0, 0,
};
float man2_points[] = {
	    -2.234,      0.558, // 0
	     2.234,      2.234, // 1
	     2.234,      6.701, // 2
	     2.583,     14.691, // 3
	     1.369,     25.847, // 4
	     0.324,     36.773, // 5
	    12.739,     38.323, // 6
	    13.798,     24.414, // 7
	     7.304,     31.837, // 8
	    10.782,     31.854, // 9
	     8.813,     27.868, // 10
	    13.269,     31.368, // 11
	    20.233,     29.910, // 12
	    13.783,     27.892, // 13
	     8.935,      6.701, // 14
	     6.701,      0.000, // 15
	    14.520,      1.117, // 16
	    -0.415,     16.980, // 17
	     5.585,     11.169, // 18
	    11.169,     13.403, // 19
	     5.746,     16.671, // 20
	    14.040,     15.496, // 21
	    17.910,     14.948  // 22
};
int man2_lines[] = {
	2, 3, 0, 0, 0,
	2, 0, 0, 0, 0,
	0, 1, 0, 0, 0,
	4, 3, 0, 0, 0,
	7, 4, 0, 0, 0,
	4, 5, 0, 0, 0,
	5, 6, 0, 0, 0,
	9, 8, 0, 0, 0,
	10, 7, 0, 0, 0,
	11, 6, 0, 0, 0,
	11, 12, 0, 0, 0,
	12, 13, 0, 0, 0,
	13, 7, 0, 0, 0,
	16, 15, 0, 0, 0,
	15, 14, 0, 0, 0,
	14, 3, 0, 0, 0,
	19, 18, 0, 0, 0,
	18, 17, 0, 0, 0,
	17, 4, 0, 0, 0,
	22, 21, 0, 0, 0,
	21, 20, 0, 0, 0,
	20, 4, 0, 0, 0,
};
float man3_points[] = {
	    16.423,      1.866, // 0
	    20.902,      2.613, // 1
	    11.197,      7.838, // 2
	     2.532,     14.398, // 3
	     1.342,     25.332, // 4
	     0.317,     36.040, // 5
	    12.486,     37.560, // 6
	    13.523,     23.928, // 7
	     7.158,     31.203, // 8
	     9.704,     31.726, // 9
	     8.211,     27.247, // 10
	    13.005,     30.743, // 11
	    19.409,     29.486, // 12
	    13.508,     27.337, // 13
	     4.852,      5.972, // 14
	    -0.746,      0.000, // 15
	     4.106,      0.746, // 16
	     7.838,     16.423, // 17
	    16.423,     13.810, // 18
	    20.529,     16.050, // 19
	    -5.225,     16.050, // 20
	     1.866,     10.824, // 21
	     5.972,      8.958  // 22
};
int man3_lines[] = {
	2, 3, 0, 0, 0,
	2, 0, 0, 0, 0,
	0, 1, 0, 0, 0,
	4, 3, 0, 0, 0,
	7, 4, 0, 0, 0,
	4, 5, 0, 0, 0,
	5, 6, 0, 0, 0,
	9, 8, 0, 0, 0,
	10, 7, 0, 0, 0,
	11, 6, 0, 0, 0,
	11, 12, 0, 0, 0,
	12, 13, 0, 0, 0,
	13, 7, 0, 0, 0,
	16, 15, 0, 0, 0,
	15, 14, 0, 0, 0,
	14, 3, 0, 0, 0,
	19, 18, 0, 0, 0,
	18, 17, 0, 0, 0,
	17, 4, 0, 0, 0,
	22, 21, 0, 0, 0,
	21, 20, 0, 0, 0,
	20, 4, 0, 0, 0,
};
float mandie1_points[] = {
	    -0.561,      5.050, // 0
	     6.172,      1.122, // 1
	    11.761,      8.233, // 2
	    -2.244,     14.589, // 3
	     1.410,     26.608, // 4
	     2.244,     33.666, // 5
	    12.905,     37.594, // 6
	    14.204,     25.133, // 7
	     7.519,     32.775, // 8
	    10.100,     27.494, // 9
	     8.416,     20.761, // 10
	    13.660,     32.292, // 11
	    19.077,     25.811, // 12
	    14.188,     28.714, // 13
	     5.096,      6.273, // 14
	    -0.784,      0.000, // 15
	     4.313,      0.784, // 16
	    20.761,     33.666, // 17
	    25.249,     38.716, // 18
	    29.177,     43.205, // 19
	   -10.661,     26.372, // 20
	   -16.272,     26.933, // 21
	   -19.638,     31.421  // 22
};
int mandie1_lines[] = {
	2, 3, 0, 0, 0,
	2, 0, 0, 0, 0,
	0, 1, 0, 0, 0,
	4, 3, 0, 0, 0,
	7, 4, 0, 0, 0,
	4, 5, 0, 0, 0,
	5, 6, 0, 0, 0,
	9, 8, 0, 0, 0,
	10, 7, 0, 0, 0,
	11, 6, 0, 0, 0,
	11, 12, 0, 0, 0,
	12, 13, 0, 0, 0,
	13, 7, 0, 0, 0,
	16, 15, 0, 0, 0,
	15, 14, 0, 0, 0,
	14, 3, 0, 0, 0,
	19, 18, 0, 0, 0,
	18, 17, 0, 0, 0,
	17, 4, 0, 0, 0,
	22, 21, 0, 0, 0,
	21, 20, 0, 0, 0,
	20, 4, 0, 0, 0,
};
float mandie2_points[] = {
	    -2.928,      2.343, // 0
	     8.198,      1.757, // 1
	    15.226,      2.928, // 2
	    -4.099,      5.271, // 3
	    12.071,      6.628, // 4
	    12.977,     14.288, // 5
	    25.000,     13.000, // 6
	    26.353,      1.757, // 7
	    18.000,     11.000, // 8
	    19.000,      8.000, // 9
	    16.397,      0.586, // 10
	    25.000,      6.000, // 11
	    29.866,      1.171, // 12
	    25.767,      4.685, // 13
	     8.784,      4.099, // 14
	    -1.171,      0.586, // 15
	     5.271,      0.000, // 16
	    32.208,      3.513, // 17
	    39.822,      2.928, // 18
	    45.092,      2.928, // 19
	     1.757,      5.856, // 20
	    -5.856,      6.442, // 21
	    -7.028,      1.171  // 22
};
int mandie2_lines[] = {
	2, 3, 0, 0, 0,
	2, 0, 0, 0, 0,
	0, 1, 0, 0, 0,
	4, 3, 0, 0, 0,
	7, 4, 0, 0, 0,
	4, 5, 0, 0, 0,
	5, 6, 0, 0, 0,
	9, 8, 0, 0, 0,
	10, 7, 0, 0, 0,
	11, 6, 0, 0, 0,
	11, 12, 0, 0, 0,
	12, 13, 0, 0, 0,
	13, 7, 0, 0, 0,
	16, 15, 0, 0, 0,
	15, 14, 0, 0, 0,
	14, 3, 0, 0, 0,
	19, 18, 0, 0, 0,
	18, 17, 0, 0, 0,
	17, 4, 0, 0, 0,
	22, 21, 0, 0, 0,
	21, 20, 0, 0, 0,
	20, 4, 0, 0, 0,
};

void man_process(int num)
{
	int remove = 0;
	ACTOR *actor = man[num];
	
	if (actor->hit) {
		if (actor->frame < 5) {
			actor->timer = 0;
			actor->frame = 5;
			actor->anim = 0;
		}
		actor->anim++;
		if (actor->anim == 16) {
			actor->anim = 0;
			actor->frame = 6;
			actor->timer++;
		}
	} else {
	
		if (actor->dx == 0) {
			actor->dx = 1;
		}
		actor->x += actor->dx;
		
		actor->timer++;
		
		if (actor->timer == 1000) {
			actor->timer = 0;
			actor->dx = -actor->dx;
		}
		
		if (actor->x > SECTORS * SECTOR_DIMENSION)
			actor->x -= SECTORS * SECTOR_DIMENSION;
		
		if (actor->x < 0)
			actor->x += SECTORS * SECTOR_DIMENSION;
	
		actor->anim++;
		if (actor->anim == 16) {
			actor->anim = 0;
			actor->frame++;
			if (actor->frame == 4) actor->frame = 0;
		}
	}
	
	{
		float d = actor->x - alienship.x;
		if (d > SECTORS * SECTOR_DIMENSION / 2) {
			d -= SECTORS * SECTOR_DIMENSION;
		}
		if (d < -SECTORS * SECTOR_DIMENSION / 2) {
			d += SECTORS * SECTOR_DIMENSION;
		}
		if ( d > 3000 || d < -3000 || alienship.y > 3000) {
			if (actor->hit && actor->timer >= 100) {
				remove = 1;
			} else {
				if (sector_place_man(actor)) remove = 1;
			}
		}
		if ((!actor->hit) && d < 100 && d > -100) {
			int i;
			for (i = 0; i < 2; i++) {
				actor->x += actor->dx;
				actor->anim ++;
				if (actor->anim == 16) {
					actor->anim = 0;
					actor->frame++;
					if (actor->frame == 4) actor->frame = 0;
				}
			}
		}
	}
	
	if (remove) {
		mans_num--;
		if (mans_num > 0) {
			man[num] = man[mans_num];
			man_process(num);
		}
	}
}

static void man_draw(ACTOR *actor, int x, int y)
{
	if (actor->dx > 0) {
		if (actor->frame == 0) draw_(x, y, points(man0), lines(man0), man0_points, man1_points, man0_lines, actor->anim / 16.0);
		if (actor->frame == 1) draw_(x, y, points(man1), lines(man1), man1_points, man2_points, man1_lines, actor->anim / 16.0);
		if (actor->frame == 2) draw_(x, y, points(man2), lines(man2), man2_points, man3_points, man2_lines, actor->anim / 16.0);
		if (actor->frame == 3) draw_(x, y, points(man3), lines(man3), man3_points, man0_points, man3_lines, actor->anim / 16.0);
	
		if (actor->frame == 5) draw_(x, y, points(mandie1), lines(mandie1), mandie1_points, mandie2_points, mandie1_lines, actor->anim / 16.0);
		if (actor->frame == 6) draw_(x, y, points(mandie2), lines(mandie2), mandie2_points, mandie2_points, mandie2_lines, actor->anim / 16.0);
	}
	if (actor->dx < 0) {
		if (actor->frame == 0) m_draw_(x, y, points(man0), lines(man0), man0_points, man1_points, man0_lines, actor->anim / 16.0);
		if (actor->frame == 1) m_draw_(x, y, points(man1), lines(man1), man1_points, man2_points, man1_lines, actor->anim / 16.0);
		if (actor->frame == 2) m_draw_(x, y, points(man2), lines(man2), man2_points, man3_points, man2_lines, actor->anim / 16.0);
		if (actor->frame == 3) m_draw_(x, y, points(man3), lines(man3), man3_points, man0_points, man3_lines, actor->anim / 16.0);
	
		if (actor->frame == 5) m_draw_(x, y, points(mandie1), lines(mandie1), mandie1_points, mandie2_points, mandie1_lines, actor->anim / 16.0);
		if (actor->frame == 6) m_draw_(x, y, points(mandie2), lines(mandie2), mandie2_points, mandie2_points, mandie2_lines, actor->anim / 16.0);
	}
}

ACTOR *man_init(void)
{
	ACTOR *actor;
	if (mans_total == TOTAL_MANS) return NULL;
	actor = &(all_mans[mans_total]);
	actor_init(actor);
	bound_(points(man0), man0_points, &actor->l, &actor->t, &actor->r, &actor->b);
	actor->draw = man_draw;
	
	if ((rand() >> 8) & 1) actor->dx = 1; else {
		float t = actor->l;
		actor->dx = -1;
		actor->l = -actor->r;
		actor->r = -t;
	}
	
	mans_total++;
	return actor;
}
